<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>UNWAHA Gaming Store</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Vite -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <!-- Gaming Theme CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('css/gaming.css')); ?>">
</head>

<body class="font-sans antialiased">

<div class="gaming-bg">

    <!-- Navbar -->
    <header class="navbar">
        <div style="display:flex;align-items:center;justify-content:space-between;padding:14px 20px;">
            <h2 style="font-weight:900;letter-spacing:3px;">
                🎮 UNWAHA GAMING STORE
            </h2>

            <?php if(auth()->guard()->check()): ?>
                <?php echo $__env->make('layouts.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php endif; ?>
        </div>
    </header>

    <!-- Layout -->
    <div style="display:flex;min-height:calc(100vh - 70px);">

        <!-- Sidebar -->
        <?php if(auth()->guard()->check()): ?>
        <aside class="sidebar">

            
            <?php if(Route::has('dashboard')): ?>
                <a href="<?php echo e(route('dashboard')); ?>">🏠 Dashboard</a>
            <?php endif; ?>

            
            <?php if(Auth::user()->role === 'admin' && Route::has('admin.products')): ?>
                <a href="<?php echo e(route('admin.products')); ?>">🛒 Produk</a>
            <?php endif; ?>

            
            <?php if(Auth::user()->role === 'seller' && Route::has('seller.orders')): ?>
                <a href="<?php echo e(route('seller.orders')); ?>">📦 Order</a>
            <?php endif; ?>

            
            <?php if(Route::has('profile.edit')): ?>
                <a href="<?php echo e(route('profile.edit')); ?>">⚙️ Profile</a>
            <?php endif; ?>

            <hr style="border:1px solid rgba(255,255,255,0.15); margin:15px 10px;">

            
            <form method="POST" action="<?php echo e(route('logout')); ?>">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn" style="width:100%;">
                    🚪 Logout
                </button>
            </form>

        </aside>
        <?php endif; ?>

        <!-- Main Content -->
        <main style="flex:1;padding:25px;">

            
            <?php if(isset($header)): ?>
                <div class="glass" style="margin-bottom:20px;">
                    <?php echo e($header); ?>

                </div>
            <?php endif; ?>

            
            <div class="card">
                <?php echo e($slot ?? ($content ?? '')); ?>

            </div>

        </main>

    </div>

</div>

</body>
</html>
<?php /**PATH C:\xampp1\htdocs\POS\POS\resources\views/layouts/app.blade.php ENDPATH**/ ?>