<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>UNWAHA Gaming Store</title>

    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,700,900&display=swap" rel="stylesheet" />

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css']); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/gaming.css')); ?>">
</head>

<body class="gaming-bg">

<div class="min-h-screen flex flex-col items-center justify-center relative px-4">

    <!-- BRANDING HEADER (TIDAK BLUR) -->
    <div class="relative z-20 text-center mb-10">
        <h1 class="text-4xl md:text-5xl font-black tracking-tight text-cyan-300">
            UNWAHA GAMING STORE
        </h1>
    </div>

    <!-- LOGIN CARD (TETAP) -->
    <div class="relative z-20 w-full max-w-md glass card">
        <?php echo e($slot); ?>

    </div>

</div>

<!-- FOOTER (TETAP) -->
<footer class="absolute bottom-4 w-full text-center text-xs text-gray-400 z-20">
    © <?php echo e(date('Y')); ?> UNWAHA Gaming Store. All rights reserved.
</footer>

</body>
</html>
<?php /**PATH C:\xampp1\htdocs\POS\POS\resources\views/layouts/guest.blade.php ENDPATH**/ ?>