<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

// --- INI YANG KURANG TADI ---
use App\Http\Controllers\ShopController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\OrderController;
// ----------------------------

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

Route::get('/', function () {
    return redirect()->route('login');
});

// ... kode route dashboard ...

// Fitur Keranjang Belanja Lengkap
Route::get('/cart', [CartController::class, 'index'])->name('cart.index');
Route::post('/cart/add/{id}', [CartController::class, 'addToCart'])->name('cart.add');
Route::delete('/cart/remove/{id}', [CartController::class, 'destroy'])->name('cart.destroy');

// ... rute keranjang sebelumnya ...

// Fitur Checkout & Riwayat Pesanan
Route::post('/checkout', [OrderController::class, 'checkout'])->name('checkout');
Route::get('/orders', [OrderController::class, 'index'])->name('orders.index');

// ... kode rute orders ...

// AREA KHUSUS ADMIN
    Route::prefix('admin')->group(function () {
        // ... rute products yang sudah ada ...
        Route::get('/products', [App\Http\Controllers\ProductController::class, 'index'])->name('admin.products');
        Route::get('/products/create', [App\Http\Controllers\ProductController::class, 'create'])->name('products.create');
        Route::post('/products', [App\Http\Controllers\ProductController::class, 'store'])->name('products.store');
        Route::get('/products/{id}/edit', [App\Http\Controllers\ProductController::class, 'edit'])->name('products.edit');
        Route::put('/products/{id}', [App\Http\Controllers\ProductController::class, 'update'])->name('products.update');
        Route::delete('/products/{id}', [App\Http\Controllers\ProductController::class, 'destroy'])->name('products.destroy');

        // TAMBAHAN BARU: RUTE KELOLA PESANAN
        Route::get('/orders', [App\Http\Controllers\OrderController::class, 'indexAdmin'])->name('admin.orders');
        Route::put('/orders/{id}', [App\Http\Controllers\OrderController::class, 'updateStatus'])->name('admin.orders.update');
    });

// ... kode profile ...

Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/dashboard', [ShopController::class, 'index'])->name('dashboard');
    Route::post('/cart/add/{id}', [CartController::class, 'addToCart'])->name('cart.add');

    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__ . '/auth.php';
