<x-app-layout>
    <div class="py-12 bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h1 class="text-3xl font-bold text-gray-900 mb-8">Riwayat Pesanan Saya</h1>

            @if(session('success'))
                <div class="mb-6 bg-green-500 text-white px-6 py-4 rounded-xl shadow-lg flex items-center gap-3">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                    <span class="font-bold text-lg">{{ session('success') }}</span>
                </div>
            @endif

            @if($orders->isEmpty())
                <div class="text-center py-20 bg-white rounded-2xl shadow-sm">
                    <p class="text-gray-500 text-lg">Anda belum pernah berbelanja.</p>
                    <a href="{{ route('dashboard') }}" class="text-indigo-600 font-bold hover:underline mt-2 inline-block">Mulai Belanja</a>
                </div>
            @else
                <div class="space-y-8">
                    @foreach($orders as $order)
                    <div class="bg-white rounded-2xl shadow-md overflow-hidden border border-gray-100">
                        <div class="bg-gray-50 px-6 py-4 border-b border-gray-100 flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
                            <div>
                                <p class="text-xs text-gray-500 uppercase font-bold tracking-wider">Nomor Order</p>
                                <p class="text-gray-900 font-bold">#ORD-{{ str_pad($order->id, 5, '0', STR_PAD_LEFT) }}</p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500 uppercase font-bold tracking-wider">Tanggal</p>
                                <p class="text-gray-900">{{ $order->created_at->format('d M Y, H:i') }}</p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500 uppercase font-bold tracking-wider">Total Bayar</p>
                                <p class="text-indigo-600 font-black text-lg">Rp {{ number_format($order->total_price) }}</p>
                            </div>
                            <div>
                                <span class="px-3 py-1 rounded-full text-xs font-bold bg-green-100 text-green-700 uppercase tracking-wide">
                                    {{ $order->status }}
                                </span>
                            </div>
                        </div>

                        <div class="p-6">
                            <ul class="divide-y divide-gray-100">
                                @foreach($order->items as $item)
                                <li class="py-4 flex items-center justify-between">
                                    <div class="flex items-center gap-4">
                                        <div class="bg-gray-100 w-12 h-12 rounded-lg flex items-center justify-center text-gray-400">
                                            📦
                                        </div>
                                        <div>
                                            <p class="font-bold text-gray-800">{{ $item->product->name }}</p>
                                            <p class="text-sm text-gray-500">{{ $item->qty }} barang x Rp {{ number_format($item->price) }}</p>
                                        </div>
                                    </div>
                                    <p class="font-semibold text-gray-900">Rp {{ number_format($item->price * $item->qty) }}</p>
                                </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    @endforeach
                </div>
            @endif
        </div>
    </div>
</x-app-layout>