<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>UNWAHA Gaming Store</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Vite -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <!-- Gaming Theme CSS -->
    <link rel="stylesheet" href="{{ asset('css/gaming.css') }}">
</head>

<body class="font-sans antialiased">

<div class="gaming-bg">

    <!-- Navbar -->
    <header class="navbar">
        <div style="display:flex;align-items:center;justify-content:space-between;padding:14px 20px;">
            <h2 style="font-weight:900;letter-spacing:3px;">
                🎮 UNWAHA GAMING STORE
            </h2>

            @auth
                @include('layouts.navigation')
            @endauth
        </div>
    </header>

    <!-- Layout -->
    <div style="display:flex;min-height:calc(100vh - 70px);">

        <!-- Sidebar -->
        @auth
        <aside class="sidebar">

            {{-- Dashboard --}}
            @if(Route::has('dashboard'))
                <a href="{{ route('dashboard') }}">🏠 Dashboard</a>
            @endif

            {{-- Admin --}}
            @if(Auth::user()->role === 'admin' && Route::has('admin.products'))
                <a href="{{ route('admin.products') }}">🛒 Produk</a>
            @endif

            {{-- Seller --}}
            @if(Auth::user()->role === 'seller' && Route::has('seller.orders'))
                <a href="{{ route('seller.orders') }}">📦 Order</a>
            @endif

            {{-- Profile --}}
            @if(Route::has('profile.edit'))
                <a href="{{ route('profile.edit') }}">⚙️ Profile</a>
            @endif

            <hr style="border:1px solid rgba(255,255,255,0.15); margin:15px 10px;">

            {{-- Logout --}}
            <form method="POST" action="{{ route('logout') }}">
                @csrf
                <button type="submit" class="btn" style="width:100%;">
                    🚪 Logout
                </button>
            </form>

        </aside>
        @endauth

        <!-- Main Content -->
        <main style="flex:1;padding:25px;">

            {{-- Page Header --}}
            @isset($header)
                <div class="glass" style="margin-bottom:20px;">
                    {{ $header }}
                </div>
            @endisset

            {{-- Content --}}
            <div class="card">
                {{ $slot ?? ($content ?? '') }}
            </div>

        </main>

    </div>

</div>

</body>
</html>
