<x-app-layout>
    <div class="py-12 bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

            <div class="relative bg-indigo-600 rounded-3xl p-6 sm:p-10 mb-10 shadow-xl overflow-hidden text-white flex flex-col justify-center min-h-[200px]">
                <div class="relative z-10 max-w-2xl">
                    <h1 class="text-3xl sm:text-5xl font-extrabold tracking-tight mb-4">
                        Gadget Impianmu
                    </h1>
                    <p class="text-lg text-indigo-100 mb-6">
                        Dapatkan koleksi gadget terbaru dengan harga terbaik dan garansi resmi. Promo terbatas hari ini!
                    </p>
                </div>
                <div class="absolute top-0 right-0 -mr-20 -mt-20 w-80 h-80 rounded-full bg-white opacity-10 blur-3xl"></div>
                <div class="absolute bottom-0 right-20 w-40 h-40 rounded-full bg-indigo-400 opacity-20 blur-2xl"></div>
            </div>

            <div class="fixed top-24 right-5 z-50 space-y-4">
                @if(session('success'))
                    <div x-data="{ show: true }" x-show="show" x-init="setTimeout(() => show = false, 3000)"
                         class="bg-emerald-500 text-white px-6 py-4 rounded-xl shadow-2xl flex items-center gap-3 animate-bounce">
                        <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" /></svg>
                        <span class="font-bold">{{ session('success') }}</span>
                    </div>
                @endif

                @if(session('error'))
                    <div x-data="{ show: true }" x-show="show" x-init="setTimeout(() => show = false, 4000)"
                         class="bg-red-500 text-white px-6 py-4 rounded-xl shadow-2xl flex items-center gap-3 animate-pulse">
                        <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
                        <span class="font-bold">{{ session('error') }}</span>
                    </div>
                @endif
            </div>

            <div class="flex items-center justify-between mb-6">
                <h2 class="text-2xl font-bold text-gray-800">Produk Terbaru</h2>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
                @forelse($products as $product)
                <div class="bg-white rounded-2xl shadow-sm hover:shadow-xl transition-all duration-300 border border-gray-100 flex flex-col overflow-hidden group">
                    
                    <div class="h-56 bg-gray-100 relative flex items-center justify-center overflow-hidden group-hover:bg-gray-200 transition">
                        @if($product->image)
                            <img src="{{ asset('storage/' . $product->image) }}" alt="{{ $product->name }}" class="w-full h-full object-cover group-hover:scale-105 transition duration-500">
                        @else
                            <svg class="w-16 h-16 text-gray-300 group-hover:scale-110 transition duration-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                            </svg>
                        @endif
                        
                        @if($product->stock > 0)
                            <div class="absolute top-3 right-3 bg-white/80 backdrop-blur px-3 py-1 rounded-full text-xs font-bold text-gray-700 shadow-sm z-10">
                                Stok {{ $product->stock }}
                            </div>
                        @else
                            <div class="absolute top-3 right-3 bg-red-600 text-white px-3 py-1 rounded-full text-xs font-bold shadow-sm z-10">
                                Stok Habis
                            </div>
                        @endif
                    </div>

                    <div class="p-5 flex-1 flex flex-col justify-between">
                        <div>
                            <h3 class="text-lg font-bold text-gray-900 mb-1 group-hover:text-indigo-600 transition truncate">{{ $product->name }}</h3>
                            <p class="text-sm text-gray-500 line-clamp-2">{{ $product->description }}</p>
                        </div>
                        
                        <div class="mt-4 flex items-center justify-between">
                            <div class="flex flex-col">
                                <span class="text-xs text-gray-400">Harga</span>
                                <span class="text-lg font-black text-gray-900">Rp {{ number_format($product->price, 0, ',', '.') }}</span>
                            </div>
                            
                            @if($product->stock > 0)
                                <form action="{{ route('cart.add', $product->id) }}" method="POST">
                                    @csrf
                                    <button type="submit" class="w-10 h-10 rounded-full bg-gray-900 text-white flex items-center justify-center hover:bg-indigo-600 transition shadow-lg hover:shadow-indigo-500/50" title="Tambah ke Keranjang">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path></svg>
                                    </button>
                                </form>
                            @else
                                <button disabled class="w-10 h-10 rounded-full bg-gray-300 text-gray-500 flex items-center justify-center cursor-not-allowed" title="Stok Habis">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"></path></svg>
                                </button>
                            @endif
                        </div>
                    </div>
                </div>
                @empty
                <div class="col-span-full py-12 text-center">
                    <div class="inline-flex bg-gray-100 p-4 rounded-full mb-3">
                        <svg class="w-10 h-10 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 12H4"></path></svg>
                    </div>
                    <p class="text-gray-500">Belum ada produk yang tersedia.</p>
                </div>
                @endforelse
            </div>

        </div>
    </div>
</x-app-layout>