<x-app-layout>
    <div class="py-12 bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

            <h1 class="text-3xl font-bold text-gray-900 mb-8 flex items-center gap-3">
                <svg class="w-8 h-8 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z">
                    </path>
                </svg>
                Keranjang Belanja
            </h1>

            @if (session('success'))
                <div class="mb-6 bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-3 rounded shadow-sm flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                    {{ session('success') }}
                </div>
            @endif

            @if (session('error'))
                <div class="mb-6 bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-3 rounded shadow-sm flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                    {{ session('error') }}
                </div>
            @endif

            @if ($carts->isEmpty())
                <div class="bg-white rounded-2xl shadow-sm p-12 text-center">
                    <div class="mb-4 inline-flex items-center justify-center w-20 h-20 bg-indigo-50 rounded-full">
                        <svg class="w-10 h-10 text-indigo-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-2">Keranjangmu Kosong</h3>
                    <p class="text-gray-500 mb-6">Wah, sepertinya kamu belum memilih barang apapun.</p>
                    <a href="{{ route('dashboard') }}"
                        class="inline-flex items-center px-6 py-3 bg-indigo-600 hover:bg-indigo-700 text-white font-bold rounded-xl transition shadow-lg hover:shadow-indigo-500/30">
                        Mulai Belanja
                    </a>
                </div>
            @else
                <div class="flex flex-col lg:flex-row gap-8">

                    <div class="lg:w-2/3">
                        <div class="bg-white rounded-2xl shadow-sm overflow-hidden border border-gray-100">
                            <div class="overflow-x-auto">
                                <table class="w-full text-left">
                                    <thead class="bg-gray-50 border-b border-gray-100">
                                        <tr>
                                            <th class="py-4 px-6 text-xs font-bold text-gray-500 uppercase tracking-wider">
                                                Produk</th>
                                            <th class="py-4 px-6 text-xs font-bold text-gray-500 uppercase tracking-wider text-center">
                                                Jumlah</th>
                                            <th class="py-4 px-6 text-xs font-bold text-gray-500 uppercase tracking-wider text-right">
                                                Total</th>
                                            <th class="py-4 px-6 text-center"></th>
                                        </tr>
                                    </thead>
                                    <tbody class="divide-y divide-gray-100">
                                        @foreach ($carts as $item)
                                            <tr class="hover:bg-gray-50/50 transition">
                                                <td class="py-5 px-6">
                                                    <div class="flex items-center gap-4">
                                                        <div class="h-16 w-16 bg-gray-100 rounded-lg flex items-center justify-center text-gray-400 overflow-hidden border border-gray-200">
                                                            @if($item->product->image)
                                                                <img src="{{ asset('storage/' . $item->product->image) }}" alt="{{ $item->product->name }}" class="h-full w-full object-cover">
                                                            @else
                                                                <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                                                </svg>
                                                            @endif
                                                        </div>
                                                        <div>
                                                            <p class="font-bold text-gray-900">
                                                                {{ $item->product->name }}</p>
                                                            <p class="text-sm text-gray-500">Rp
                                                                {{ number_format($item->product->price) }} / unit</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td class="py-5 px-6 text-center">
                                                    <span class="inline-block px-3 py-1 bg-gray-100 rounded-lg font-bold text-gray-700 text-sm">
                                                        {{ $item->qty }}
                                                    </span>
                                                </td>
                                                <td class="py-5 px-6 text-right font-bold text-indigo-600 text-lg">
                                                    Rp {{ number_format($item->product->price * $item->qty) }}
                                                </td>
                                                <td class="py-5 px-6 text-center">
                                                    <form action="{{ route('cart.destroy', $item->id) }}" method="POST">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit"
                                                            class="p-2 text-gray-400 hover:text-red-500 hover:bg-red-50 rounded-full transition"
                                                            title="Hapus Item">
                                                            <svg class="w-5 h-5" fill="none" stroke="currentColor"
                                                                viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    stroke-width="2"
                                                                    d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16">
                                                                </path>
                                                            </svg>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="mt-6">
                            <a href="{{ route('dashboard') }}"
                                class="text-indigo-600 font-semibold hover:underline flex items-center gap-2">
                                &larr; Lanjut Belanja
                            </a>
                        </div>
                    </div>

                    <div class="lg:w-1/3">
                        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100 sticky top-10">
                            <h3 class="text-lg font-bold text-gray-900 mb-6 border-b border-gray-100 pb-4">Rincian
                                Pembayaran</h3>

                            <div class="space-y-3 mb-6">
                                <div class="flex justify-between text-gray-600">
                                    <span>Subtotal Produk</span>
                                    <span class="font-medium">Rp {{ number_format($total) }}</span>
                                </div>
                                <div class="flex justify-between text-gray-600">
                                    <span>Pajak (PPN)</span>
                                    <span class="font-medium text-green-600">Gratis</span>
                                </div>
                                <div class="flex justify-between text-gray-600">
                                    <span>Biaya Admin</span>
                                    <span class="font-medium">Rp 0</span>
                                </div>
                            </div>

                            <div class="flex justify-between items-center mb-8 pt-4 border-t border-gray-100">
                                <span class="text-lg font-bold text-gray-800">Total Bayar</span>
                                <span class="text-2xl font-black text-indigo-600">Rp {{ number_format($total) }}</span>
                            </div>

                            <div class="mt-6">
                                <form action="{{ route('checkout') }}" method="POST">
                                    @csrf
                                    <button type="submit"
                                        class="w-full flex items-center justify-center px-6 py-3 border border-transparent text-base font-medium rounded-md shadow-sm text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-colors duration-200">
                                        Checkout Sekarang
                                    </button>
                                </form>
                            </div>

                            <p class="text-xs text-center text-gray-400 mt-4 flex justify-center items-center gap-1">
                                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                                    </path>
                                </svg>
                                Transaksi Aman & Terenkripsi
                            </p>
                        </div>
                    </div>

                </div>
            @endif

        </div>
    </div>
</x-app-layout>