<x-app-layout>
    <div class="py-12 bg-gray-50 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

            {{-- HERO SECTION --}}
            <div class="relative bg-indigo-600 rounded-3xl p-6 sm:p-10 mb-10 shadow-xl overflow-hidden text-white flex flex-col justify-center min-h-[200px]">
                <div class="relative z-10 max-w-2xl">
                    <h1 class="text-3xl sm:text-5xl font-extrabold tracking-tight mb-4">
                        Gadget Impianmu
                    </h1>
                    <p class="text-lg text-indigo-100 mb-0 sm:mb-6 max-w-lg">
                        Dapatkan koleksi gadget terbaru dengan harga terbaik dan garansi resmi.
                    </p>
                </div>
                {{-- Dekorasi Background --}}
                <div class="absolute top-0 right-0 -mr-20 -mt-20 w-80 h-80 rounded-full bg-white opacity-10 blur-3xl pointer-events-none"></div>
                <div class="absolute bottom-0 right-20 w-40 h-40 rounded-full bg-indigo-400 opacity-20 blur-2xl pointer-events-none"></div>
            </div>

            {{-- NOTIFIKASI TOAST (Diperbaiki agar tidak terlalu lebar di HP) --}}
            <div class="fixed top-24 right-4 z-50 space-y-4 max-w-[90vw] sm:max-w-sm w-full pointer-events-none">
                @if(session('success'))
                    <div x-data="{ show: true }" x-show="show" x-init="setTimeout(() => show = false, 3000)"
                         class="bg-emerald-500 text-white px-4 py-3 rounded-xl shadow-2xl flex items-center gap-3 animate-bounce pointer-events-auto">
                        <svg class="h-6 w-6 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" /></svg>
                        <span class="font-bold text-sm">{{ session('success') }}</span>
                    </div>
                @endif

                @if(session('error'))
                    <div x-data="{ show: true }" x-show="show" x-init="setTimeout(() => show = false, 4000)"
                         class="bg-red-500 text-white px-4 py-3 rounded-xl shadow-2xl flex items-center gap-3 animate-pulse pointer-events-auto">
                        <svg class="h-6 w-6 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
                        <span class="font-bold text-sm">{{ session('error') }}</span>
                    </div>
                @endif
            </div>

            {{-- HEADER SECTION --}}
            <div class="flex items-center justify-between mb-6">
                <h2 class="text-2xl font-bold text-gray-800">Produk Terbaru</h2>
            </div>

            {{-- GRID PRODUK (Responsive Grid) --}}
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
                @forelse($products as $product)
                {{-- KARTU PRODUK --}}
                {{-- Tambahkan 'h-full' agar semua kartu dalam satu baris tingginya sama --}}
                <div class="bg-white rounded-2xl shadow-sm hover:shadow-xl transition-all duration-300 border border-gray-100 flex flex-col overflow-hidden group h-full">
                    
                    {{-- BAGIAN GAMBAR --}}
                    <div class="h-56 bg-gray-100 relative flex-shrink-0 overflow-hidden group-hover:bg-gray-200 transition">
                        @if($product->image)
                            <img src="{{ url('gambar/' . $product->image) }}" alt="{{ $product->name }}" class="w-full h-full object-cover group-hover:scale-110 transition duration-500">
                        @else
                            <div class="w-full h-full flex items-center justify-center">
                                <svg class="w-16 h-16 text-gray-300 group-hover:scale-110 transition duration-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                </svg>
                            </div>
                        @endif
                        
                        {{-- Badge Stok --}}
                        <div class="absolute top-3 right-3 z-10">
                            @if($product->stock > 0)
                                <span class="bg-white/90 backdrop-blur px-3 py-1 rounded-full text-xs font-bold text-gray-700 shadow-sm">
                                    Stok {{ $product->stock }}
                                </span>
                            @else
                                <span class="bg-red-600 text-white px-3 py-1 rounded-full text-xs font-bold shadow-sm">
                                    Habis
                                </span>
                            @endif
                        </div>
                    </div>

                    {{-- BAGIAN KONTEN (Flex Grow agar tombol selalu di bawah) --}}
                    <div class="p-5 flex flex-col flex-1">
                        {{-- Judul & Deskripsi --}}
                        <div class="flex-1">
                            <h3 class="text-lg font-bold text-gray-900 mb-1 group-hover:text-indigo-600 transition leading-tight">
                                {{ $product->name }}
                            </h3>
                            <p class="text-sm text-gray-500 line-clamp-2 mt-1">
                                {{ $product->description }}
                            </p>
                        </div>
                        
                        {{-- Harga & Tombol (Footer Kartu) --}}
                        <div class="mt-4 pt-4 border-t border-gray-50 flex items-center justify-between gap-2">
                            <div class="flex flex-col">
                                <span class="text-xs text-gray-400">Harga</span>
                                <span class="text-lg font-black text-indigo-600">
                                    Rp {{ number_format($product->price, 0, ',', '.') }}
                                </span>
                            </div>
                            
                            {{-- Tombol Cart --}}
                            @if($product->stock > 0)
                                <form action="{{ route('cart.add', $product->id) }}" method="POST">
                                    @csrf
                                    <button type="submit" class="w-10 h-10 rounded-full bg-gray-900 text-white flex items-center justify-center hover:bg-indigo-600 transition-colors shadow-lg hover:shadow-indigo-500/30 active:scale-95" title="Tambah ke Keranjang">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path></svg>
                                    </button>
                                </form>
                            @else
                                <button disabled class="w-10 h-10 rounded-full bg-gray-200 text-gray-400 flex items-center justify-center cursor-not-allowed">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"></path></svg>
                                </button>
                            @endif
                        </div>
                    </div>
                </div>
                {{-- END KARTU --}}
                
                @empty
                <div class="col-span-full py-12 text-center bg-white rounded-2xl border border-gray-100 shadow-sm">
                    <div class="inline-flex bg-gray-50 p-4 rounded-full mb-3">
                        <svg class="w-10 h-10 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 12H4"></path></svg>
                    </div>
                    <p class="text-gray-500 font-medium">Belum ada produk yang tersedia.</p>
                </div>
                @endforelse
            </div>

        </div>
    </div>
</x-app-layout>