<x-guest-layout>
    <div class="mb-8">
        <h2 class="text-3xl font-bold text-gray-900">Buat Akun</h2>
        <p class="text-gray-500 text-sm mt-2">Mulai perjalanan bisnis Anda di sini.</p>
    </div>

    <form method="POST" action="{{ route('register') }}" class="space-y-6" novalidate>
        @csrf

        <div>
            <label for="name" class="block text-sm font-medium text-gray-700 mb-1">Nama Lengkap</label>
            <input id="name" type="text" name="name" :value="old('name')" required autofocus
                class="w-full px-4 py-3.5 rounded-xl bg-gray-50 border {{ $errors->has('name') ? 'border-red-500 ring-1 ring-red-500' : 'border-gray-200' }} text-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 transition duration-200"
                placeholder="Contoh: Budi Santoso">
            @error('name') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>

        <div>
            <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Alamat Email</label>
            <input id="email" type="email" name="email" :value="old('email')" required
                class="w-full px-4 py-3.5 rounded-xl bg-gray-50 border {{ $errors->has('email') ? 'border-red-500 ring-1 ring-red-500' : 'border-gray-200' }} text-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 transition duration-200"
                placeholder="nama@email.com">
            @error('email') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>

        <div>
            <label for="password" class="block text-sm font-medium text-gray-700 mb-1">Password</label>
            <input id="password" type="password" name="password" required autocomplete="new-password"
                class="w-full px-4 py-3.5 rounded-xl bg-gray-50 border {{ $errors->has('password') ? 'border-red-500 ring-1 ring-red-500' : 'border-gray-200' }} text-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 transition duration-200"
                placeholder="Minimal 8 karakter">
            
            <div class="mt-3 hidden transition-all duration-300" id="strength-container">
                <div class="flex justify-between items-center mb-1">
                    <span class="text-xs font-bold text-gray-500" id="strength-text">Weak</span>
                </div>
                <div class="w-full bg-gray-200 rounded-full h-2">
                    <div class="h-2 rounded-full transition-all duration-500" style="width: 0%" id="strength-bar"></div>
                </div>
            </div>

            @error('password') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>

        <div>
            <label for="password_confirmation" class="block text-sm font-medium text-gray-700 mb-1">Konfirmasi Password</label>
            <input id="password_confirmation" type="password" name="password_confirmation" required
                class="w-full px-4 py-3.5 rounded-xl bg-gray-50 border {{ $errors->has('password_confirmation') ? 'border-red-500 ring-1 ring-red-500' : 'border-gray-200' }} text-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 transition duration-200"
                placeholder="Ulangi password">
        </div>

        <div class="pt-4">
            <button class="w-full bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-3.5 rounded-xl shadow-lg hover:shadow-indigo-500/30 transition duration-300 transform hover:-translate-y-0.5 active:translate-y-0">
                {{ __('Daftar Sekarang') }}
            </button>
        </div>

        <div class="text-center mt-4 pb-4">
            <p class="text-sm text-gray-600">
                Sudah punya akun? 
                <a href="{{ route('login') }}" class="font-bold text-indigo-600 hover:text-indigo-800 transition">Login disini</a>
            </p>
        </div>
    </form>

    <script>
        const passwordInput = document.getElementById('password');
        const strengthContainer = document.getElementById('strength-container');
        const strengthBar = document.getElementById('strength-bar');
        const strengthText = document.getElementById('strength-text');

        passwordInput.addEventListener('input', function() {
            const val = passwordInput.value;
            
            // Tampilkan bar jika user mulai mengetik
            if(val.length > 0) {
                strengthContainer.classList.remove('hidden');
            } else {
                strengthContainer.classList.add('hidden');
            }

            // Logika Skor (0 - 4)
            let score = 0;
            if (val.length >= 8) score++;
            if (val.match(/[A-Z]/)) score++;
            if (val.match(/[0-9]/)) score++;
            if (val.match(/[^A-Za-z0-9]/)) score++;

            // Reset Kelas Warna Dulu (Penting agar tidak tertumpuk)
            strengthBar.classList.remove('bg-red-500', 'bg-yellow-500', 'bg-blue-500', 'bg-green-500');
            strengthText.classList.remove('text-red-500', 'text-yellow-500', 'text-blue-500', 'text-green-500');

            // Set Warna Baru
            let width = '0%';
            let text = '';

            // Menggunakan IF biasa agar Tailwind mendeteksi nama class stringnya
            if (score <= 1) {
                width = '25%';
                strengthBar.classList.add('bg-red-500');
                strengthText.classList.add('text-red-500');
                strengthText.innerText = 'Lemah';
            } else if (score === 2) {
                width = '50%';
                strengthBar.classList.add('bg-yellow-500');
                strengthText.classList.add('text-yellow-500');
                strengthText.innerText = 'Sedang';
            } else if (score === 3) {
                width = '75%';
                strengthBar.classList.add('bg-blue-500');
                strengthText.classList.add('text-blue-500');
                strengthText.innerText = 'Kuat';
            } else {
                width = '100%';
                strengthBar.classList.add('bg-green-500');
                strengthText.classList.add('text-green-500');
                strengthText.innerText = 'Sangat Kuat!';
            }

            strengthBar.style.width = width;
        });
    </script>
</x-guest-layout>