<x-app-layout>
    <div class="py-12 bg-gray-50 min-h-screen">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            
            <div class="flex items-center justify-between mb-8">
                <div>
                    <h1 class="text-3xl font-extrabold text-gray-900 tracking-tight">Edit Produk</h1>
                    <p class="mt-2 text-sm text-gray-600">Perbarui informasi untuk produk <span class="font-semibold text-indigo-600">{{ $product->name }}</span>.</p>
                </div>
                <a href="{{ route('admin.products') }}" class="group flex items-center px-4 py-2 bg-gray-200 text-gray-800 text-sm font-bold rounded-lg hover:bg-gray-300 transition-colors duration-200 shadow-sm">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2 text-gray-500 group-hover:text-gray-700 transition-colors duration-200" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M9.707 16.707a1 1 0 01-1.414 0l-6-6a1 1 0 010-1.414l6-6a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l4.293 4.293a1 1 0 010 1.414z" clip-rule="evenodd" />
                    </svg>
                    Kembali
                </a>
            </div>

            <div class="bg-white rounded-2xl shadow-xl overflow-hidden border-t-4 border-green-500">
                <div class="p-8 sm:p-10">
                    <form action="{{ route('products.update', $product->id) }}" method="POST" enctype="multipart/form-data" class="space-y-8">
                        @csrf
                        @method('PUT')

                        <div>
                            <label for="name" class="block text-sm font-bold text-gray-900 mb-2">Nama Produk</label>
                            <div class="mt-1">
                                <input type="text" name="name" id="name" value="{{ $product->name }}" required
                                       class="block w-full rounded-xl border-gray-300 px-4 py-3 text-gray-900 shadow-sm focus:border-green-500 focus:ring-green-500 font-medium transition duration-200">
                            </div>
                        </div>

                        <div class="flex gap-6 items-start">
                            @if($product->image)
                                <div class="shrink-0">
                                    <p class="text-xs font-bold text-gray-500 mb-2">Gambar Saat Ini:</p>
                                    <img src="{{ asset('storage/' . $product->image) }}" class="h-24 w-24 object-cover rounded-lg border border-gray-300 shadow-sm">
                                </div>
                            @endif

                            <div class="grow">
                                <label class="block text-sm font-bold text-gray-900 mb-2">Ganti Foto (Opsional)</label>
                                <input type="file" name="image" accept="image/*"
                                       class="block w-full text-sm text-gray-500
                                              file:mr-4 file:py-2.5 file:px-4
                                              file:rounded-full file:border-0
                                              file:text-sm file:font-bold
                                              file:bg-green-50 file:text-green-700
                                              hover:file:bg-green-100
                                              cursor-pointer border border-gray-300 rounded-xl p-2">
                                <p class="mt-1 text-xs text-gray-500">Biarkan kosong jika tidak ingin mengubah gambar.</p>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 gap-y-8 gap-x-6 sm:grid-cols-2">
                            
                            <div>
                                <label for="price" class="block text-sm font-bold text-gray-900 mb-2">Harga Jual</label>
                                <div class="relative rounded-xl shadow-sm">
                                    <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-4">
                                        <span class="text-gray-500 font-bold sm:text-sm">Rp</span>
                                    </div>
                                    <input type="number" name="price" id="price" value="{{ $product->price }}" required min="0"
                                           class="block w-full rounded-xl border-gray-300 pl-12 pr-4 py-3 text-gray-900 focus:border-green-500 focus:ring-green-500 placeholder-gray-400 sm:text-sm font-semibold transition duration-200">
                                </div>
                            </div>

                            <div>
                                <label for="stock" class="block text-sm font-bold text-gray-900 mb-2">Stok Saat Ini</label>
                                <div class="mt-1">
                                    <input type="number" name="stock" id="stock" value="{{ $product->stock }}" required min="0"
                                           class="block w-full rounded-xl border-gray-300 px-4 py-3 text-gray-900 shadow-sm focus:border-green-500 focus:ring-green-500 placeholder-gray-400 sm:text-sm font-medium transition duration-200">
                                </div>
                            </div>
                        </div>

                        <div>
                            <label for="description" class="block text-sm font-bold text-gray-900 mb-2">Deskripsi Produk</label>
                            <div class="mt-1">
                                <textarea id="description" name="description" rows="5" required
                                          class="block w-full rounded-xl border-gray-300 px-4 py-3 text-gray-900 shadow-sm focus:border-green-500 focus:ring-green-500 placeholder-gray-400 sm:text-sm transition duration-200">{{ $product->description }}</textarea>
                            </div>
                        </div>

                        <div class="pt-6 border-t border-gray-100 flex items-center justify-end space-x-4">
                            <a href="{{ route('admin.products') }}" class="px-6 py-3 bg-white text-sm font-bold text-gray-700 rounded-xl border border-gray-300 hover:bg-gray-50 hover:text-gray-900 transition focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                                Batal
                            </a>
                            <button type="submit" class="px-8 py-3 bg-green-600 text-sm font-bold text-white rounded-xl shadow-lg hover:bg-green-700 hover:shadow-xl transition focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 transform hover:-translate-y-0.5 flex items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
                                </svg>
                                Simpan Perubahan
                            </button>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
</x-app-layout>