<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Product;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        // 1. Buat Akun Admin
        User::create([
            'name' => 'Admin Toko',
            'email' => 'admin@toko.com',
            'password' => bcrypt('password'),
            'role' => 'admin',
        ]);

        // 2. Buat Akun User Biasa
        User::create([
            'name' => 'Budi Pembeli',
            'email' => 'budi@gmail.com',
            'password' => bcrypt('password'),
            'role' => 'user',
        ]);

        // 3. Buat Produk Contoh
        Product::create([
            'name' => 'Laptop Gaming',
            'price' => 15000000,
            'stock' => 10,
            'description' => 'Laptop spek dewa untuk koding dan game.',
        ]);
        
        Product::create([
            'name' => 'Mouse Wireless',
            'price' => 150000,
            'stock' => 50,
            'description' => 'Mouse enak digenggam anti delay.',
        ]);
    }
}